<?php
$metaTitle = "Sampling to create mathematical function graphs";
$metaDescription = "An explanation of how sampling creates the graphs in a math grapher.";
include('../includes/nonLoopTop.php');
include('../includes/getLatestsvgPHPGrapher.php');
$brdNum="sampling-0"; // For svg id's
?>
<style type="text/css">
.int{border:1px solid #5b8a9b;border-radius:0.4em;padding:0 0.5em 0.8em;
-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none }
.info{width:200px;font-size:0.9em;display:inline-block}
body{background:#eff;max-width:100%}
svg{overflow:hidden}
.svgphpgrapherwarn{color:#d00;font-weight:bold}
.svgphpWrap{position:relative;margin-left:10px}
.svgHtml{position:absolute;font-size:0.85em}
@font-face {font-family: MathJax_Math-italic;
    src: url('MathJax_Math-Italic.eot');
    src: url('MathJax_Math-Italic.eot?#iefix') format('embedded-opentype'),
			url('MathJax_Math-Italic.woff') format('woff');
	 }
@font-face {font-family: MathJax_Main;
    src: url('MathJax_Main-Regular.eot');
    src: url('MathJax_Main-Regular.eot?#iefix') format('embedded-opentype'),
			url('MathJax_Main-Regular.woff') format('woff') }
i,em{font-family:MathJax_Math-italic,"Times New Roman",Times,serif;font-size:1.2em;font-style:normal /* To stop double italic on MacOS */}			
pre, code{font-size:1.1em}
pre{margin:0 0 0 1em;white-space: pre-wrap}
.longCode{padding:0;margin:0 0 0 1em}
.current{color:#888;font-size:0.85em}
code.indent{margin:0 0 0 1em}
.intmath{}
</style>


<?php
include('../includes/nonLoopHeader.php');
?><h1><?php echo $metaTitle; ?></h1>


<h2>Sampling Functions</h2>
<p>Graph sketching is a vital mathematical skill, whether we have access to computers or not. When <b>modelling</b> a data set, it's very useful to have a variety of curve shapes to choose from.</p>
<p>Curve sketching questions usually say something like:</p>
<blockquote>
<p> "Sketch the given function, indicating main features of the graph."</p>
</blockquote>
<p>When first learning to draw such function curves, students are taught to complete a table of values, something like this:</p>

<table>
<tr><td><em>x</em></td>
<td>-3</td><td>-2</td><td>-1</td><td>0</td><td>1</td><td>2</td><td>3</td>
<tr><td><em>y</em></td>
<td>-2</td><td>-4</td><td>-5</td><td>0</td><td>2</td><td>4</td><td>6</td>
</table>

<p>As long as it's a "nice", well-bahaved curve in the region <span class="intmath">&minus;3 < <em>x</em> < 3</span>, then it's not a bad starting point.</p>
<p>However, a lot of students continue to do this for more complicated functions, and end up in a lot of trouble. It's important to have a general idea what the curve will look like before you start, so you don't miss key attributes of the curve.</p>
<p>Whenever you see a graph of a function drawn on a computer, it involves <b>sampling</b>. The constraints are you want to produce a smooth curve, but not have a large file size (or require a lot of computer processing time).</p>
<p>Let's look at some examples</p>

<h3>A symmetric curve</h3>
<p>In this example, we've sampled 4 <i>x</i>-values, completed the table, put the dots on the graph and joined them with straight lines.</p>

<table class="postTable mathTable">
<?php
$ptsArr = [ [-3, 0.1], [-1, 0.5], [1, 0.5], [3, 0.1] ];
echo "<tr><td><i>x</i></td>";
foreach($ptsArr as $key=>$pt) {
	echo "<td>".$ptsArr[$key][0]."</td>";
}
echo "</tr>";
echo "<tr><td><i>y</i></td>";
foreach($ptsArr as $key=>$pt) {
	echo "<td>".$ptsArr[$key][1]."</td>";	
}
echo "</tr>";
?>
</table>


<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-4; $xMax=4; $yMin=0;  $yMax=1.2; 
$padding = 20;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 3;




// $dy = '' or 0 means no y-axis
$svgArr[] = axes(1,1,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
foreach($ptsArr as $key=>$pt) {
	$attrs = 'stroke:none; fill:#165a71';
	$svgArr[] = dot($pt,3,$attrs, $brdParams);
	$myattrs = 'stroke:#faf; stroke-width:1;shape-rendering:crispEdges';
	$svgArr[] = segment([$ptsArr[$key][0],0], [$ptsArr[$key][0], $ptsArr[$key][1]], $myattrs,$brdParams);	
	if($key>0) {
		$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
		$svgArr[] = segment($ptsArr[$key-1],$ptsArr[$key],$attrs, $brdParams);
		
	}
}
//
doOutput($svgArr,$htmlArr);
?>

<p>We could have been a bit smarter and joined them with a curve, something like this. What do you think the function for this curve is?</p>

<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 200;
$xMin=-4; $xMax=4; $yMin=0;  $yMax=1; 

list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
//
$xAxisVbl = "x";	$yAxisVbl = "y";
// $dy = '' or 0 means no y-axis
$gridAttrs = 'stroke:#ccc; stroke-width:1; shape-rendering:crispEdges';
$svgArr[] = axes(1,0.5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
//
$ptsArr = [ [-4, -0.19], [-3, 0.1], [-1, 0.5], [1, 0.5], [3, 0.1], [4, -0.19] ];
$tension = 0.5;
$isClosed = false;
$numSegs = 30;
$plist = getCurvePoints($ptsArr, $tension, $isClosed, $numSegs);
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = path($plist,'','', $attrs,$brdParams);
$attrs = 'stroke:none; fill:#165a71';
foreach($ptsArr as $pt) {
	$svgArr[] = dot($pt,3,$attrs, $brdParams);
}
doOutput($svgArr,$htmlArr);
?>

<p>I've seen this kind of sketch many times. It looks reasonable, but it's wrong. The student has not sampled enough points and the curve doe not capture all the required characteristics.</p>
<p>The student remembers that we should sample some more points to get a more accurate curve. So we try 7 points this time. The spacing between each point is 1.5 units.</p>


<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-3.95; $xMax=3.95; $yMin=0;  $yMax=1.2; 
$padding = 20;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 6;

// $dy = '' or 0 means no y-axis
$svgArr[] = axes(1,0.5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = plot("1/(x^2+1)",'','',$numPts, $attrs,$brdParams);
$myattrs = 'stroke:#faf; stroke-width:1;shape-rendering:crispEdges';
$xunitlength = $brdParams["xunitlength"];
$ox = $brdParams["ox"];
//for($k = ($width/$numPts)-$padding; $k < $width; $k+=$width/($numPts)) {
for($k = 0; $k < $width; $k+=$width/($numPts)) {	
//echo "$k; ".($width/$numPts)."<br>";
	$svgArr[] = segment([$xMin+($k-$padding)/$xunitlength,0], [$xMin+($k-$padding)/$xunitlength, (1/(pow(($k - $ox)/$xunitlength,2)+1))], $myattrs,$brdParams);	
}
//

doOutput($svgArr,$htmlArr);

?>

<p>Now our curve is taking on quite a different shape. We don't know if <span class="intmath"><em>y</em> = 1</span> is the highest point, but we have a better curve than our first attempt.</p>

<p>The next example uses 50 sample points, and we can finally get a good idea of the final shape from this.</p>
<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-4; $xMax=4; $yMin=0;  $yMax=1.2; 
$padding = 20;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 50;

// $dy = '' or 0 means no y-axis
$svgArr[] = axes(1,0.5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams

//$svgArr[] = plot("x^4 - 0.1x^3 - 6x^2 + 7x + 0.5",'','',$numPts, $attrs,$brdParams);
$myattrs = 'stroke:#faf; stroke-width:1;shape-rendering:crispEdges';
$xunitlength = $brdParams["xunitlength"];
$ox = $brdParams["ox"];
//for($k = ($width/$numPts)-$padding; $k < $width; $k+=$width/($numPts)) {
for($k = 0; $k < $width; $k+=$width/($numPts)) {	
//echo "$k; ".($width/$numPts)."<br>";
	$svgArr[] = segment([$xMin+($k-$padding)/$xunitlength,0], [$xMin+($k-$padding)/$xunitlength, (1/(pow(($k - $ox)/$xunitlength,2)+1))], $myattrs,$brdParams);	
}
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = plot("1/(x^2+1)",'','',$numPts, $attrs,$brdParams);
//
doOutput($svgArr,$htmlArr);
?>

<p>The curve we've been trying to draw is actually `y = 1/(x^2+1)`.</p>
<p> The maximum point is indeed `(0, 1)` and by considering what happens when <em>x</em> approaches negative infinity (on the left) and positive infinity (on the right), the denominator of the fraction becomes very large, so the fraction value becomes very small, and approaches 0.</p>
<p>Our first attempt indicated the curve passed through the <em>x</em>-axis, but we can see now that this is incorrect.</p>
<p>With enough sample points, we have captured all the required details on the graph. We can see the maximum point, and we can see the <em>x</em>-axis is an asymptote for the graph.</p>
<p> Very few students will draw up a table with 50 values! It's much better to examine the function first, and to consider what happens at some key points (like <span class="intmath"><em>x</em> = 0</span>), and also what happens when <em>x</em> is very small, and very large. Another hint for drawing this function is that it is going to be <b>symmetric</b> about the y-axis, because of the `x^2` term in the denominator.</p>


<h3>A polynomial</h3>
<p>It's a good idea to know the general shapes of quadratic, cubic, quartic and quintic curves. If you know in advance the likely shape of your polynomial curve, it is easier to draw with less data points, and you're more likely to include all the key features.</p>
<p>Let's find some typical values, using 10 sample points.</p>


<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-4; $xMax=4; $yMin=-60;  $yMax=180; 
$padding = 15;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";
$svgArr[] = axes(1,100,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams

$ptsArr = [[-3.5, 61.1], [-2.6, 149], [-1.8, 183.6], [-0.9, 161.5], [0, 94.2], [0.9, 8.3], [1.8, -54.5], [2.7, -37.5], [3.6, 131]];
$attrs = 'stroke:none; fill:#165a71';
foreach($ptsArr as $pt) {
	$svgArr[] = dot($pt,3,$attrs, $brdParams);
}
//
doOutput($svgArr,$htmlArr);
?>


<p>It seems to be a fairly well-behaved curve. We confidently join the data points with a smooth curve, then move on to the next question.</p>

<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-4; $xMax=4; $yMin=-60;  $yMax=180; 
$padding = 15;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 80;

// $dy = '' or 0 means no y-axis
$svgArr[] = axes(1,50,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = plot("(x+8)(x+4)(x-1)(x-3)",'','',$numPts, $attrs,$brdParams);
//
doOutput($svgArr,$htmlArr);
?>

<p>But wait! Here's the original question: "Sketch <span class="intmath"><em>y</em> = <em>x</em><sup>4</sup> + 8<em>x</em><sup>3</sup> &minus; 13<em>x</em><sup>2</sup>-92<em>x</em> + 96</span>". This is a quartic (highest power is 4), and this should alert us that there will be 2 arms of the curve that go off to positive infinity. However, our curve has one arm going off to negative infinity (or so it seems), and the other going to popsitive infinity. There must be something wrong.</p>
<p>Let's try again with a wider view (we increase the range of <em>x</em>-values on the <em>x</em>-axis).</p>

<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-10; $xMax=4; $yMin=-250;  $yMax=220; 
$padding = 15;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 100;

// $dy = '' or 0 means no y-axis
$svgArr[] = axes(1,100,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = plot("(x+8)(x+4)(x-1)(x-3)",'','',$numPts, $attrs,$brdParams);
//
doOutput($svgArr,$htmlArr);
?>

<p>That's better! Our curve shows the 2 arms that go off to positive infinity (it's positive because the number infront of the <span class="intmath"><em>x</em><sup>4</sup></span> term is positive). There's no need to zoom out any further since we can now see the main features of the graph.</p>

<h3>More complicated curve</h3>

<p>Here's one that catches a lot of students. If you take the "plug values into a table" approach, you can get a really messy graph.</p>
<p>Our first try uses values that are about 0.5 units apart.</p>


<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-3.4; $xMax=3.4; $yMin=-10;  $yMax=10; 
$padding = 15;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 16;

// $dy = '' or 0 means no y-axis
$svgArr[] = axes(pi()/2,5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = plot("tan(x)",'','',$numPts, $attrs,$brdParams);
$myattrs = 'stroke:#faf; stroke-width:1;shape-rendering:crispEdges';
$xunitlength = $brdParams["xunitlength"];
$yunitlength = $brdParams["yunitlength"];
$ox = $brdParams["ox"];
for($k = 0; $k < $width; $k+=$width/($numPts)) {	
	$svgArr[] = segment([$xMin+($k-$padding)/$xunitlength,0], [$xMin+($k-$padding)/$xunitlength, (tan(($k - $ox)/$xunitlength))], $myattrs,$brdParams);		
}
//
doOutput($svgArr,$htmlArr);
?>

<p>Once again, we draw a smooth curve through our points:</p>






<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-3.4; $xMax=3.4; $yMin=-10;  $yMax=10; 

list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
//
$xAxisVbl = "x";	$yAxisVbl = "y";
// $dy = '' or 0 means no y-axis
$gridAttrs = 'stroke:#ccc; stroke-width:1; shape-rendering:crispEdges';
$svgArr[] = axes(1,5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
//
$ptsArr = [ [-3.76, -0.72], [-3.29, -0.15], [-2.82, 0.33], [-2.35, 1.02], [-1.87, 3.2], [-1.4, -5.83], [-0.93, -1.34], [-0.46, -0.49], [0.02, 0.02], [0.49, 0.53], [0.96, 1.44], [1.43, 7.32], [1.91, -2.86], [2.38, -0.95], [2.85, -0.3], [3.33, 0.19], [3.8, 0.77] ] ;
$tension = 0.7;
$isClosed = false;
$numSegs = 20;
$plist = getCurvePoints($ptsArr, $tension, $isClosed, $numSegs);
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = path($plist,'','', $attrs,$brdParams);
$attrs = 'stroke:none; fill:#165a71';
foreach($ptsArr as $pt) {
	$svgArr[] = dot($pt,3,$attrs, $brdParams);
}
doOutput($svgArr,$htmlArr);
?>

<p>But it's not the correct graph. It has some of the right features (it suggests some repetition is going on and that it passes through `(0, 0)`), but it doesn't capture the main featuers.</p>

<p>Let's try again, this time sampling 70 points. Surely that shouild be enough?</p>

<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-3.4; $xMax=3.4; $yMin=-10;  $yMax=10; 
$padding = 15;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 71;
// $dy = '' or 0 means no y-axis
$svgArr[] = axes(pi()/2,5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = plot("tan(x)",'','',$numPts, $attrs,$brdParams);
//
doOutput($svgArr,$htmlArr);
?>

<p>This time it's still not good. We have a large gap between the first and second arms (what does that gap mean?), and a jagged join between the second and third arms.</p>
<p>Let's have another go with 250 points.</p>

<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 220;
$xMin=-3.4; $xMax=3.4; $yMin=-10;  $yMax=10; 
$padding = 15;
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";

$numPts = 250;
// $dy = '' or 0 means no y-axis
$svgArr[] = axes(pi()/2,5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
$attrs = 'stroke:#165a71; stroke-width:1.5; fill:none';
$svgArr[] = plot("tan(x)",'','',$numPts, $attrs,$brdParams);
//
doOutput($svgArr,$htmlArr);
?>

<p>We can now see what the curve is meant to look like (it's actually the curve of the tangent function, `y = tan(x)`).</p>
<p>The problem with most graphing software is you often need to fiddle around like this to get a complete curve, and avoid unwanted joins.</p>
<p>In my <a href="https://www.intmath.com/cg5/svgphpgrapher-syntax.php">svgPHPGrapher</a>, I've built in the option to easily plot a curve where the slope is quite high, even approaching vertical.</p>

<h3>Plotting the Inverse for a better curve</h3>
<p>My approach in the next plot was to graph the inverse function `x = arctan(y)`. This curve is mostly flat when looked at from the side (that is, turning the axes 90&deg;, which is what an inerse function is all about).</p>
<p>This gives just one arm, as follows. It only needs aboround 35 sample points to produce a smooth curve.</p>

<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 200;
$xMin=-4; $xMax=7.5; $yMin=-10;  $yMax=10; 
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";
// $dy = '' or 0 means no y-axis
$svgArr[] = axes(pi(),5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
$attrs = 'stroke:#165a71; stroke-width:1.5;fill:none';	
$svgArr[] = plot("atan(y)",$yMin,$yMax,35, $attrs,$brdParams);
//
doOutput($svgArr,$htmlArr);
?>

<p>I repeat that arm across the board. I also inserted vertical asymtotes (the dashed lines) to indicate the curve gets closer and closer to those lines, but never touches them.</p>

<?php
$boardID = "svgphp-$brdNum"; $brdNum++;
$width = 310; $height = 200;
$xMin=-4; $xMax=7.5; $yMin=-10;  $yMax=10; 
list($svgArr, $htmlArr, $brdParams) = initBoard($boardID, $width, $height, $xMin, $xMax, $yMin, $yMax, $axesType, $res1, $res2, $res3, $padding);
$xAxisVbl = "x";	$yAxisVbl = "y";
// $dy = '' or 0 means no y-axis
$svgArr[] = axes(pi(),5,"labels",0,0, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams);  //$dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $attrs,$brdParams
for($k=-pi();$k<=2*pi();$k+=pi()) {
	$attrs = 'stroke:#165a71; stroke-width:1.5;fill:none';	
	$svgArr[] = plot("atan(y)+$k",$yMin,$yMax,45, $attrs,$brdParams);
	$attrs = 'stroke:#165a71; stroke-width:1; stroke-dasharray:5,5; shape-rendering:crispEdges';	
	$svgArr[] = line([$k+pi()/2, $yMin], [$k+pi()/2, $yMax], $attrs,$brdParams);
}
//
doOutput($svgArr,$htmlArr);
?>

<h2>Conclusion</h2>

<p>While the "plug values into the function and create a table, plot the points then join them" is a reaosnable place to start when teaching curve plotting, I feel it's important students should learn basic shapes of graphs. They are then less likely to have problems when sketching the curves by hand, and trying to use computer graphics software.</p>






    </div> <!-- wrapper -->
  </body>
</html>
